import java.io.*;

public class SensorFile {
	public static void main(String[] args) {
		SensorReading[] list= new SensorReading[4];
		list[0]= new SensorReading("S1", 1, 50.0);
		list[1]= new SensorReading("S22", 2, 70.0);
		list[2]= new SensorReading("S308", 4, 90.0);
		list[3]= new SensorReading("S4", 7, 0.0);
		try {
			FileWriter f= new FileWriter("sensor.txt");
			BufferedWriter b= new BufferedWriter(f);
			PrintWriter out= new PrintWriter(b);
			writeData(list, out);
			out.close();
			
			FileReader fin= new FileReader("sensor.txt");
			BufferedReader in= new BufferedReader(fin);
			SensorReading[] newList= readData(in);
			in.close();
			
			for (int i=0; i < newList.length; i++)
				System.out.println(newList[i]);
				
		} catch(IOException e) {
			System.out.println(e);
		}
	}
	
	public static void writeData(SensorReading[] s, PrintWriter out) throws IOException {
		out.println(s.length);
		for (int i= 0; i < s.length; i++) {
			String id= s[i].getID();
			int time= s[i].getTime();
			double reading= s[i].getReading();
			out.println(id + "," + time + "," + reading);
		}
	}
	
	public static SensorReading[] readData(BufferedReader in) throws IOException {
		int n= Integer.parseInt(in.readLine());
		SensorReading[] sArr= new SensorReading[n];
		for (int i=0; i < n; i++) {
			sArr[i]= new SensorReading();
			String str = in.readLine();
			String [] parts = str.split(",");
			sArr[i].setID(parts[0]);
			sArr[i].setTime(Integer.parseInt(parts[1]));
			sArr[i].setReading(Double.parseDouble(parts[2]));			
		}
		return sArr;
	}
}